//
//  TodoItemDetail.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

struct TodoItemDetail: View {
    let item: TodoItem
    
    var body: some View {
        VStack(alignment: .leading) {
            Rectangle()
                .fill(item.list.color.uiColor)
                .edgesIgnoringSafeArea(.top)
                .frame(height: 210)
                .overlay(TitleOverlay(item: item))
            
            if item.notes != nil {
                Text(item.notes!)
                    .padding(.horizontal)
            }
            
            Spacer()
        }
        .navigationBarTitle("", displayMode: .inline)
    }
    
    private struct TitleOverlay: View {
        let item: TodoItem
        
        var gradient: LinearGradient {
            LinearGradient(
                gradient: Gradient(colors: [
                    Color.black.opacity(0.6),
                    Color.black.opacity(0),
                ]),
                startPoint: .bottom,
                endPoint: .init(x: 0.5, y: 0.1))
        }
        
        var body: some View {
            ZStack(alignment: .bottomLeading) {
                Rectangle().fill(gradient)
                VStack(alignment: .leading, spacing: 8) {
                    Text(item.title)
                        .font(.title)
                        .bold()
                    HStack(alignment: .firstTextBaseline) {
                        Text("Priority: ") + Text(item.priority.rawValue.capitalized).bold()
                        Spacer()
                        if item.date != nil {
                            Text("\(item.date!, formatter: Formatters.mediumDate)")
                        }
                        else {
                            Text("No Due Date")
                        }
                    }
                    .font(.subheadline)
                }
                .foregroundColor(.white)
                .padding()
            }
        }
    }
}

struct TodoItemDetail_Previews: PreviewProvider {
    static var previews: some View {
        TodoItemDetail(item: defaultTodoItems[0])
    }
}
